$(document).ready(function () {

  var element = document.getElementById('block-pv-model');
  if (element != null) {
    if (element.length !== 0) {
      $(document.getElementById('header-footer')).addClass('row-wider');
    }
  }

  /* Tooltip */

  $(".tooltip").tooltipster({
    theme: 'tooltipster-borderless',
    functionInit: function (instance, helper) {
      var content = $(helper.origin).find('.pvm-Tooltip').detach();
      instance.content(content);
    },
    functionReady: function (instance, helper) {
      $('#myfield_description').attr('aria-hidden', false);
    },
    functionAfter: function (instance, helper) {
      $('#myfield_description').attr('aria-hidden', true);
    }
  });

  $('.tooltip')
      .focus(function () {
        $(this).tooltipster('open');
        if ($(".pvm-Menu_Choices").is(":visible")) {
          /* User has tabbed away from the menu */
          $(".pvm-Menu_Choices").removeClass("open");
        }
      })
      .blur(function () {
        $(this).tooltipster('close');
      });


  /* Menu */

  $(document).on("click", function (event) {
    var $target = $(event.target);
    if ($target.hasClass("pvm-Menu_Trigger")) {
      event.preventDefault();
      $(".pvm-Menu_Choices").toggleClass("open");
    }
    else {
      if ($(".pvm-Menu_Choices").is(":visible")) { /* menu is open */
        if (!document.getElementById('modelMenu').contains(event.target)) {
          /* click is outside menu */
          $(".pvm-Menu_Choices").removeClass("open");
        }
      }
    }
  });


  /* Popup */

  //open popup
  $("#popup-trigger").click(function (e) {
    e.preventDefault();
    $("#popup-overlay").show();
    $("#popup-close").focus();
  });

  //close popup
  $("#popup-close").click(function (e) {
    e.preventDefault();
    $("#popup-overlay").hide();
  });

  // Need to keep tab navigation inside popup:
  $("#popup-close").blur(function (e) {
    $(e.target).focus();
  });


});
